#pragma once
#include "Config.h"
//////////////////////////////////////////////////////////////////////////////////
#ifdef DLLMANAGER_EXPORTS
	#define DLLMANAGER_API __declspec(dllexport)
#else
	#define DLLMANAGER_API __declspec(dllimport)
#endif
//////////////////////////////////////////////////////////////////////////////////
#define	kSimIMSIdKey					"IMSI"
#define kSimDefaultIMSId				"2020168745"

#define	kSimVoiceMailModeKey			"VMMode"

#define	kSimVoiceMailNumberKey			"VMNumber"
#define kSimDefaultVMNumber				"123"

#define	kSimVoiceMailNumberTypeKey		"VMNumberType"
#define	kSimDefaultVMNumberType			kNumberingPlanUnknown

#define	kSimVoiceMailNameKey			"VMName"
#define kSimDefaultVMName				"Voicemail"

#define	kSimInsertedKey					"SimIns"
#define kSimDefaultInserted				1
//////////////////////////////////////////////////////////////////////////////////
class DLLMANAGER_API CConfigSIM : public CConfig
{
private:
	// CIMI
	CString mIMSI;
	// CSVM
	CString mVMName;
	CString mVMNumber;
	int mVMNumberType;
	int mVMMode;

	Bool  mSIMInserted;
protected:
	DECLARE_SERIAL(CConfigSIM);
public:
	CConfigSIM() {};
	CConfigSIM(CDllManager* iDllManager);
	virtual ~CConfigSIM(void);

	virtual Bool Load();
	virtual Bool Save();

	virtual Bool IsSIMInserted();
	virtual void SetSIMInserted(Bool iSIM);

	// GET CIMI
	virtual CString GetIMSI();
	// GET CSVM
	virtual CString GetVMName();
	virtual CString GetVMNumber();
	virtual int		GetVMNumberType();
	virtual int		GetVMMode();

	// SET CIMI
	virtual void SetIMSI(CString iIMSI);
	// SET CSVM
	virtual void SetVMName(CString iName);
	virtual void SetVMNumber(CString iNumber);
	virtual void SetVMNumberType(int iType);
	virtual void SetVMMode(int iMode);
};
